package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.appbar.MaterialToolbar;
import com.payu.base.models.ErrorResponse;
import com.payu.base.models.PayUPaymentParams;
import com.payu.checkoutpro.PayUCheckoutPro;
import com.payu.checkoutpro.models.PayUCheckoutProConfig;
import com.payu.checkoutpro.utils.PayUCheckoutProConstants;
import com.payu.ui.model.listeners.PayUCheckoutProListener;
import com.payu.ui.model.listeners.PayUHashGenerationListener;
import com.vpapps.asyncTask.LoadGenerateKeys;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;


public class PayUMoneyActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String paymentGateway, payUMoneyMerchantId, payUMoneyMerchantKey;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    boolean isSandbox = false;
    public static final String SURL = Constant.SERVER_URL.replace("api/v1/","") + "app_payu_success";
    public static final String FURL = Constant.SERVER_URL.replace("api/v1/","") + "app_payu_failed";
    Button btnPay;
    ProgressDialog pDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        methods = new Methods(PayUMoneyActivity.this);
        sharedPref = new SharedPref(PayUMoneyActivity.this);

        pDialog = new ProgressDialog(this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        payUMoneyMerchantId = intent.getStringExtra("payUMoneyMerchantId");
        payUMoneyMerchantKey = intent.getStringExtra("payUMoneyMerchantKey");
        isSandbox = intent.getBooleanExtra("isSandbox", false);

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));
        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        btnPay.setOnClickListener(view -> {
            if (sharedPref.getUserMobile().isEmpty()) {
                showError(getString(R.string.err_phone_update));
            } else {
                startPayment();
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void getHash(String hashName, String hashData, PayUHashGenerationListener payUHashGenerationListener) {
        if (methods.isNetworkAvailable()) {
            LoadGenerateKeys loadGenerateKeys = new LoadGenerateKeys(new GenerateKeysListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String razorPayOrderID, String stripePaymentID, String stripeToken, String stripeEphemeralKey, String stripeCustomer, String braintreeToken, String payumoneyHash, String instamojoOrderID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if (apiSuccess.equals("1")) {
                            if (!payumoneyHash.isEmpty()) {
                                HashMap<String, String> dataMap = new HashMap<>();
                                dataMap.put(hashName, payumoneyHash);
                                payUHashGenerationListener.onHashGenerated(dataMap);
                            } else {
                                showError(message);
                            }
                        } else {
                            Toast.makeText(PayUMoneyActivity.this, message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(PayUMoneyActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_PAYUMONEY_HASH, 0, "", "", hashData, "", "", "", "", "", "", "", "", "", "", "", "", null));
            loadGenerateKeys.doWork(Constant.METHOD_PAYUMONEY_HASH, paymentGateway);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void startPayment() {
        PayUPaymentParams.Builder builder = new PayUPaymentParams.Builder();
        builder.setAmount(itemSubscriptionPlan.getAmount())
                .setIsProduction(!isSandbox)
                .setProductInfo(itemSubscriptionPlan.getTitle())
                .setKey(payUMoneyMerchantKey)
                .setTransactionId(System.currentTimeMillis() + "")
                .setFirstName(sharedPref.getUserName())
                .setEmail(sharedPref.getUserEmail())
                .setPhone(sharedPref.getUserMobile())
                .setUserCredential(sharedPref.getUserEmail())
                .setSurl(SURL)
                .setFurl(FURL);
        PayUPaymentParams payUPaymentParams = builder.build();
        PayUCheckoutProConfig payUCheckoutProConfig = new PayUCheckoutProConfig();
        payUCheckoutProConfig.setMerchantName(getString(R.string.app_name));
        payUCheckoutProConfig.setMerchantLogo(R.mipmap.app_icon);

        PayUCheckoutPro.open(PayUMoneyActivity.this, payUPaymentParams, payUCheckoutProConfig, new PayUCheckoutProListener() {
            @Override
            public void onPaymentSuccess(@NonNull Object response) {
                HashMap<String, Object> result = (HashMap<String, Object>) response;
                String payuResponse = (String) result.get(PayUCheckoutProConstants.CP_PAYU_RESPONSE);
                //  String merchantResponse = (String) result.get(PayUCheckoutProConstants.CP_MERCHANT_RESPONSE);
                try {
                    assert payuResponse != null;
                    JSONObject mainJson = new JSONObject(payuResponse);
                    String paymentId = mainJson.getString("txnid");
                    methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, paymentId);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onPaymentFailure(@NonNull Object response) {
                HashMap<String, Object> result = (HashMap<String, Object>) response;
                String payuResponse = (String) result.get(PayUCheckoutProConstants.CP_PAYU_RESPONSE);
                //    String merchantResponse = (String) result.get(PayUCheckoutProConstants.CP_MERCHANT_RESPONSE);
                try {
                    assert payuResponse != null;
                    JSONObject mainJson = new JSONObject(payuResponse);
                    String errorMessage = mainJson.getString("Error_Message");
                    showError(errorMessage);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onPaymentCancel(boolean b) {

            }

            @Override
            public void onError(@NonNull ErrorResponse errorResponse) {
                String errorMessage = errorResponse.getErrorMessage();
                Log.e("onError", "Yes");
                showError(errorMessage);
            }

            @Override
            public void generateHash(@NonNull HashMap<String, String> hashMap, @NonNull PayUHashGenerationListener payUHashGenerationListener) {
                String hashName = hashMap.get(PayUCheckoutProConstants.CP_HASH_NAME);
                String hashData = hashMap.get(PayUCheckoutProConstants.CP_HASH_STRING);
                if (!TextUtils.isEmpty(hashName) && !TextUtils.isEmpty(hashData)) {
                    //Do not generate hash from local, it needs to be calculated from server side only. Here, hashString contains hash created from your server side.
                    getHash(hashName, hashData, payUHashGenerationListener);
                }
            }

            @Override
            public void setWebViewProperties(@Nullable WebView webView, @Nullable Object o) {

            }
        });
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1118 && resultCode == 1187) {
            if (sharedPref.getUserMobile().isEmpty()) {
                showError(getString(R.string.err_phone_update));
            } else {
                startPayment();
            }
        }
    }
}
