package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.braintreepayments.api.ClientTokenCallback;
import com.braintreepayments.api.ClientTokenProvider;
import com.braintreepayments.api.DropInClient;
import com.braintreepayments.api.DropInListener;
import com.braintreepayments.api.DropInRequest;
import com.braintreepayments.api.DropInResult;
import com.braintreepayments.api.PayPalCheckoutRequest;
import com.braintreepayments.api.PayPalPaymentIntent;
import com.google.android.material.appbar.MaterialToolbar;
import com.vpapps.asyncTask.LoadBraintreeCheckout;
import com.vpapps.asyncTask.LoadGenerateKeys;
import com.vpapps.interfaces.BraintreeCheckoutListener;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.Objects;


public class PaypalActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String authToken = "", paymentGateway;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    Button btnPay;
    boolean isSandbox;
    ProgressDialog pDialog;
    DropInClient dropInClient;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        methods = new Methods(PaypalActivity.this);
        sharedPref = new SharedPref(PaypalActivity.this);

        pDialog = new ProgressDialog(this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        isSandbox = intent.getBooleanExtra("isSandbox", false);

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));

        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        btnPay.setOnClickListener(view -> {
            if (!authToken.isEmpty()) {
                launchDropIn();
            } else {
                showError(getString(R.string.paypal_payment_error_3));
            }
        });

        configureDropInClient();
        launchDropIn();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void configureDropInClient() {
        dropInClient = new DropInClient(PaypalActivity.this, new TokenProvider());
        dropInClient.setListener(new DropInListener() {
            @Override
            public void onDropInSuccess(@NonNull DropInResult dropInResult) {
                String nNonce = Objects.requireNonNull(dropInResult.getPaymentMethodNonce()).getString();
                getCheckout(nNonce);
            }

            @Override
            public void onDropInFailure(@NonNull Exception error) {
                showError(error.getMessage());
            }
        });
    }

    private class TokenProvider implements ClientTokenProvider {
        @Override
        public void getClientToken(@NonNull ClientTokenCallback clientTokenCallback) {
            getToken(clientTokenCallback);
        }
    }

    private void getToken(ClientTokenCallback clientTokenCallback) {
        if (methods.isNetworkAvailable()) {
            LoadGenerateKeys loadGenerateKeys = new LoadGenerateKeys(new GenerateKeysListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String razorPayOrderID, String stripePaymentID, String stripeToken, String stripeEphemeralKey, String stripeCustomer, String braintreeToken, String payumoneyHash, String instamojoOrderID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if (apiSuccess.equals("1")) {
                            if (braintreeToken.isEmpty()) {
                                showError(getString(R.string.err_generate_token));
                            } else {
                                authToken = braintreeToken;
                                clientTokenCallback.onSuccess(braintreeToken);
                            }
                        } else {
                            Toast.makeText(PaypalActivity.this, message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(PaypalActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_BRAINTREE_TOKEN, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", null));
            loadGenerateKeys.doWork(Constant.METHOD_BRAINTREE_TOKEN, paymentGateway);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    private void launchDropIn() {
        DropInRequest dropInRequest = new DropInRequest();
        dropInRequest.setPayPalRequest(getPaypalRequest());
        dropInClient.launchDropIn(dropInRequest);
    }

    private PayPalCheckoutRequest getPaypalRequest() {
        PayPalCheckoutRequest request = new PayPalCheckoutRequest(itemSubscriptionPlan.getAmount());
        request.setCurrencyCode(itemSubscriptionPlan.getCurrencyCode());
        request.setIntent(PayPalPaymentIntent.SALE);
        return request;
    }

    private void getCheckout(String paymentNonce) {
        if (methods.isNetworkAvailable()) {
            LoadBraintreeCheckout loadBraintreeCheckout = new LoadBraintreeCheckout(new BraintreeCheckoutListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String paymentID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if (apiSuccess.equals("1")) {
                            if (!paymentID.isEmpty()) {
                                methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, paymentID);
                            } else {
                                showError(message);
                            }
                        } else {
                            showError(message);
                        }
                    } else {
                        Toast.makeText(PaypalActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_BRAINTREE_CHECKOUT, 0, paymentNonce, "", itemSubscriptionPlan.getAmount(), "", "", "", "", "", "", "", "", "", "", "", "", null));
            loadBraintreeCheckout.doWork(Constant.METHOD_BRAINTREE_CHECKOUT);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }
}
