package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.appbar.MaterialToolbar;
import com.tenbis.library.consts.CardType;
import com.tenbis.library.listeners.OnCreditCardStateChanged;
import com.tenbis.library.models.CreditCard;
import com.tenbis.library.views.CompactCreditCardInput;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import co.paystack.android.Paystack;
import co.paystack.android.PaystackSdk;
import co.paystack.android.Transaction;
import co.paystack.android.model.Card;
import co.paystack.android.model.Charge;


public class PaystackActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    CreditCard creditCard;
    CompactCreditCardInput compactCreditCardInput;
    String paymentGateway, payStackPublicKey;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    Button btnPay;
    boolean isCardValid = false;
    ProgressDialog pDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment_paystack);

        methods = new Methods(PaystackActivity.this);
        sharedPref = new SharedPref(PaystackActivity.this);

        pDialog = new ProgressDialog(this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        payStackPublicKey = intent.getStringExtra("payStackPublicKey");

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        compactCreditCardInput = findViewById(R.id.compact_credit_card_input);
        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));
        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        PaystackSdk.initialize(this);
        PaystackSdk.setPublicKey(payStackPublicKey);

        btnPay.setOnClickListener(view -> {
            if (isCardValid && creditCard != null) {
                startPayment();
            }
        });

        compactCreditCardInput.addOnCreditCardStateChangedListener(onCreditCardStateChanged);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private Card loadCardFromForm() {
        return new Card.Builder(creditCard.getCardNumber(), creditCard.getExpiryMonth(), creditCard.getExpiryYear(), creditCard.getCvv()).build();
    }

    OnCreditCardStateChanged onCreditCardStateChanged = new OnCreditCardStateChanged() {
        @Override
        public void onCreditCardValid(@NonNull CreditCard creditCardFull) {
            isCardValid = true;
            creditCard = creditCardFull;
        }

        @Override
        public void onCreditCardNumberValid(@NonNull String s) {

        }

        @Override
        public void onCreditCardExpirationDateValid(int i, int i1) {

        }

        @Override
        public void onCreditCardCvvValid(@NonNull String s) {

        }

        @Override
        public void onCreditCardTypeFound(@NonNull CardType cardType) {

        }

        @Override
        public void onInvalidCardTyped() {
            isCardValid = false;
        }
    };

    public void startPayment() {
        pDialog.setMessage(getResources().getString(R.string.loading));
        pDialog.show();

        Charge charge = new Charge();
        charge.setCard(loadCardFromForm());
        charge.setEmail(new SharedPref(PaystackActivity.this).getUserEmail());

        double amount = Double.parseDouble(itemSubscriptionPlan.getAmount());
        charge.setAmount((int) amount * 100);

        PaystackSdk.chargeCard(PaystackActivity.this, charge, new Paystack.TransactionCallback() {
            @Override
            public void onSuccess(Transaction transaction) {
                pDialog.dismiss();
                methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, transaction.getReference());
            }

            @Override
            public void beforeValidate(Transaction transaction) {

            }

            @Override
            public void showLoading(Boolean isProcessing) {

            }

            @Override
            public void onError(Throwable error, Transaction transaction) {
                pDialog.dismiss();
                showError(error.getMessage());
            }
        });
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }
}
