package com.vpapps.onlinemp3.payment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.appbar.MaterialToolbar;
import com.razorpay.Checkout;
import com.razorpay.PaymentResultListener;
import com.vpapps.asyncTask.LoadGenerateKeys;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import org.json.JSONObject;


public class RazorPayActivity extends AppCompatActivity implements PaymentResultListener {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String paymentGateway, razorPayKey;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    Button btnPay;
    String orderId = "";
    ProgressDialog pDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        razorPayKey = intent.getStringExtra("razorPayKey");

        methods = new Methods(RazorPayActivity.this);
        sharedPref = new SharedPref(RazorPayActivity.this);

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        pDialog = new ProgressDialog(this);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));
        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        itemSubscriptionPlan.setAmount(String.valueOf((int)Double.parseDouble(itemSubscriptionPlan.getAmount())*100));

        Checkout.preload(getApplicationContext());

        btnPay.setOnClickListener(view -> {
            if (orderId.isEmpty()) {
                getOrderId();
            } else {
                startPayment();
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void getOrderId() {
        if (methods.isNetworkAvailable()) {
            LoadGenerateKeys loadGenerateKeys = new LoadGenerateKeys(new GenerateKeysListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String razorPayOrderID, String stripePaymentID, String stripeToken, String stripeEphemeralKey, String stripeCustomer, String braintreeToken, String payumoneyHash, String instamojoOrderID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if(apiSuccess.equals("1")) {
                            orderId = razorPayOrderID;
                            startPayment();
                        } else {
                            Toast.makeText(RazorPayActivity.this, message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(RazorPayActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_RAZORPAY_ORDER_ID, 0, "", "", itemSubscriptionPlan.getAmount(), "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(),"", null));
            loadGenerateKeys.doWork(Constant.METHOD_RAZORPAY_ORDER_ID, paymentGateway);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void startPayment() {
        final Activity activity = this;
        final Checkout co = new Checkout();
        co.setKeyID(razorPayKey);

        try {
            JSONObject options = new JSONObject();
            options.put("name", getString(R.string.app_name));
            options.put("description", sharedPref.getUserID().concat(" - ").concat(sharedPref.getUserName()));
            options.put("image", "https://s3.amazonaws.com/rzp-mobile/images/rzp.png");
            options.put("currency", itemSubscriptionPlan.getCurrencyCode());
            options.put("order_id", orderId);
            options.put("amount", itemSubscriptionPlan.getAmount());

            JSONObject preFill = new JSONObject();
            preFill.put("email", sharedPref.getUserEmail());
            //     preFill.put("contact", "9999999999");

            options.put("prefill", preFill);

            co.open(activity, options);
        } catch (Exception e) {
            showError(getString(R.string.err_payment_) + e.getMessage());
            e.printStackTrace();
        }
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onPaymentSuccess(String razorpayPaymentID) {
        try {
            methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, razorpayPaymentID);
        } catch (Exception e) {
            Log.e("TAG", "Exception in onPaymentSuccess", e);
        }
    }

    @Override
    public void onPaymentError(int code, String response) {
        try {
            showError(getString(R.string.payment_failed).concat(" ") + code + " " + response);
        } catch (Exception e) {
            Log.e("TAG", "Exception in onPaymentError", e);
        }
    }
}
