package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.ComponentActivity;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.appbar.MaterialToolbar;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PaymentSheetResult;
import com.stripe.android.paymentsheet.PaymentSheetResultCallback;
import com.vpapps.asyncTask.LoadGenerateKeys;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import org.jetbrains.annotations.NotNull;


public class StripeActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String paymentGateway, stripePublisherKey;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    PaymentSheet paymentSheet;
    Button btnPay;
    String paymentID = "", token, ephemeralKey, customer;
    ProgressDialog pDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        methods = new Methods(StripeActivity.this);
        sharedPref = new SharedPref(StripeActivity.this);

        pDialog = new ProgressDialog(this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        stripePublisherKey = intent.getStringExtra("stripePublisherKey");

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));
        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        PaymentConfiguration.init(this, stripePublisherKey);
        paymentSheet = new PaymentSheet((ComponentActivity) StripeActivity.this, new PaymentSheetResultCallback() {
            @Override
            public void onPaymentSheetResult(@NotNull PaymentSheetResult paymentSheetResult) {
                onPaymentResult(paymentSheetResult);
            }
        });

        btnPay.setOnClickListener(view -> getToken());
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void getToken() {
        if (methods.isNetworkAvailable()) {
            LoadGenerateKeys loadGenerateKeys = new LoadGenerateKeys(new GenerateKeysListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String razorPayOrderID, String stripePaymentID, String stripeToken, String stripeEphemeralKey, String stripeCustomer, String braintreeToken, String payumoneyHash, String instamojoOrderID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if (apiSuccess.equals("1")) {
                            if (stripeToken.isEmpty() && stripeEphemeralKey.isEmpty() && stripeCustomer.isEmpty() && stripePaymentID.isEmpty()) {
                                showError(getString(R.string.err_generate_token));
                            } else {
                                token = stripeToken;
                                ephemeralKey = stripeEphemeralKey;
                                paymentID = stripePaymentID;
                                customer = stripeCustomer;
                                startPayment();
                            }
                        } else {
                            Toast.makeText(StripeActivity.this, message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(StripeActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_STRIPE_TOKEN, 0, "", "", itemSubscriptionPlan.getAmount(), "", "", "", "", "", "", "", "", "", "", "", "", null));
            loadGenerateKeys.doWork(Constant.METHOD_STRIPE_TOKEN, paymentGateway);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void startPayment() {
        paymentSheet.presentWithPaymentIntent(
                token,
                new PaymentSheet.Configuration(
                        getString(R.string.app_name),
                        new PaymentSheet.CustomerConfiguration(
                                customer,
                                ephemeralKey
                        )
                )
        );
    }

    private void onPaymentResult(final PaymentSheetResult paymentSheetResult) {
        if (paymentSheetResult instanceof PaymentSheetResult.Canceled) {
            showError(getString(R.string.err_payment_cancel));
        } else if (paymentSheetResult instanceof PaymentSheetResult.Failed) {
            showError(getString(R.string.err_payment_failed));
        } else if (paymentSheetResult instanceof PaymentSheetResult.Completed) {
            methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, paymentID);
        }
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }
}
