package com.vpapps.utils;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class FirstItemMarginDecorator extends RecyclerView.ItemDecoration {
    private int margin;

    public FirstItemMarginDecorator(Context context, int margin) {
        this.margin = margin;
    }

    @Override
    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);

        int position = parent.getChildAdapterPosition(view);

        // Apply margin only to the first item
        if (position == 0) {
            outRect.left = margin;
        } else {
            outRect.left = 0;
        }
    }
}