package com.vpapps.utils;

import static android.Manifest.permission.POST_NOTIFICATIONS;
import static android.Manifest.permission.READ_EXTERNAL_STORAGE;
import static android.Manifest.permission.READ_MEDIA_AUDIO;
import static android.Manifest.permission.READ_MEDIA_IMAGES;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinMediationProvider;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.google.firebase.auth.FirebaseAuth;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.onesignal.OneSignal;
import com.startapp.sdk.ads.banner.Banner;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.StartAppAd;
import com.startapp.sdk.adsbase.StartAppSDK;
import com.startapp.sdk.adsbase.adlisteners.AdDisplayListener;
import com.startapp.sdk.adsbase.adlisteners.VideoListener;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.vpapps.adService.AdManagerInterAdmob;
import com.vpapps.adService.AdManagerInterApplovin;
import com.vpapps.adService.AdManagerInterStartApp;
import com.vpapps.adService.AdManagerInterUnity;
import com.vpapps.adService.AdManagerInterWortise;
import com.vpapps.adService.RewardAdAdmob;
import com.vpapps.adService.RewardAdApplovin;
import com.vpapps.adService.RewardAdStartApp;
import com.vpapps.adService.RewardAdUnity;
import com.vpapps.adService.RewardAdWortise;
import com.vpapps.adapter.AdapterPlaylistDialog;
import com.vpapps.asyncTask.LoadAddTransaction;
import com.vpapps.asyncTask.LoadLogout;
import com.vpapps.interfaces.AddTransactionListener;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.interfaces.LoggedDeviceListener;
import com.vpapps.interfaces.RewardAdListener;
import com.vpapps.item.ItemLoggedDevice;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.DownloadService;
import com.vpapps.onlinemp3.LoginActivity;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.PlayerService;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SubscriptionActivity;
import com.wortise.ads.AdError;
import com.wortise.ads.WortiseSdk;
import com.wortise.ads.banner.BannerAd;
import com.wortise.ads.interstitial.InterstitialAd;
import com.wortise.ads.rewarded.RewardedAd;
import com.wortise.ads.rewarded.models.Reward;

import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;

import javax.net.ssl.HttpsURLConnection;

import cn.refactor.library.SmoothCheckBox;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Methods {


    @SerializedName("song_image")

    private final Context context;
    private DBHelper dbHelper;
    private InterAdListener interAdListener;
    boolean isRewarded = false;

    // constructor
    public Methods(Context context) {
        this.context = context;
        dbHelper = new DBHelper(context);
    }

    public Methods(Context context, InterAdListener interAdListener) {
        this.context = context;
        this.interAdListener = interAdListener;
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public int getScreenWidth() {
        int columnWidth;
        WindowManager wm = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();

        final Point point = new Point();

        point.x = display.getWidth();
        point.y = display.getHeight();

        columnWidth = point.x;
        return columnWidth;
    }

    public int getScreenHeight() {
        int height;
        WindowManager wm = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();

        final Point point = new Point();

        point.x = display.getWidth();
        point.y = display.getHeight();

        height = point.y;
        return height;
    }

    public int convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * (metrics.densityDpi / 160f);
        return Math.round(px);
    }

    private static final DecelerateInterpolator DECCELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final AccelerateInterpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final OvershootInterpolator OVERSHOOT_INTERPOLATOR = new OvershootInterpolator(4);

    public void animateHeartButton(final View v) {
        AnimatorSet animatorSet = new AnimatorSet();

        ObjectAnimator rotationAnim = ObjectAnimator.ofFloat(v, "rotation", 0f, 360f);
        rotationAnim.setDuration(300);
        rotationAnim.setInterpolator(ACCELERATE_INTERPOLATOR);

        ObjectAnimator bounceAnimX = ObjectAnimator.ofFloat(v, "scaleX", 0.2f, 1f);
        bounceAnimX.setDuration(300);
        bounceAnimX.setInterpolator(OVERSHOOT_INTERPOLATOR);

        ObjectAnimator bounceAnimY = ObjectAnimator.ofFloat(v, "scaleY", 0.2f, 1f);
        bounceAnimY.setDuration(300);
        bounceAnimY.setInterpolator(OVERSHOOT_INTERPOLATOR);
        bounceAnimY.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
            }

            @Override
            public void onAnimationEnd(Animator animation) {
            }
        });

        animatorSet.play(bounceAnimX).with(bounceAnimY).after(rotationAnim);
        animatorSet.start();
    }

    public String milliSecondsToTimer(long milliseconds, long duration) {
        if (duration > 0) {
            String finalTimerString = "";
            String hourString = "";
            String secondsString = "";
            String minutesString = "";

            // Convert total duration into time
            int hours = (int) (milliseconds / (1000 * 60 * 60));
            int minutes = (int) (milliseconds % (1000 * 60 * 60)) / (1000 * 60);
            int seconds = (int) ((milliseconds % (1000 * 60 * 60)) % (1000 * 60) / 1000);
            // Add hours if there
            int temp_hour = (int) (duration / (1000 * 60 * 60));
            if (temp_hour != 0) {
                hourString = hours + ":";
            }

            // Prepending 0 to seconds if it is one digit
            if (seconds < 10) {
                secondsString = "0" + seconds;
            } else {
                secondsString = "" + seconds;
            }

            // Prepending 0 to minutes if it is one digit
            if (minutes < 10) {
                minutesString = "0" + minutes;
            } else {
                minutesString = "" + minutes;
            }

            finalTimerString = hourString + minutesString + ":" + secondsString;

//        // return timer string
            return finalTimerString;
        } else {
            return "0:00";
        }
    }

    public String milliSecondsToTimerDownload(long milliseconds) {
        String finalTimerString = "";
        String hourString = "";
        String secondsString = "";
        String minutesString = "";

        // Convert total duration into time
        int hours = (int) (milliseconds / (1000 * 60 * 60));
        int minutes = (int) (milliseconds % (1000 * 60 * 60)) / (1000 * 60);
        int seconds = (int) ((milliseconds % (1000 * 60 * 60)) % (1000 * 60) / 1000);
        // Add hours if there

        if (hours != 0) {
            hourString = hours + ":";
        }

        // Prepending 0 to seconds if it is one digit
        if (seconds < 10) {
            secondsString = "0" + seconds;
        } else {
            secondsString = "" + seconds;
        }

        // Prepending 0 to minutes if it is one digit
        if (minutes < 10) {
            minutesString = "0" + minutes;
        } else {
            minutesString = "" + minutes;
        }

        finalTimerString = hourString + minutesString + ":" + secondsString;

        // return timer string
        return finalTimerString;
    }

    public int getProgressPercentage(long currentDuration, long totalDuration) {
        Double percentage = (double) 0;

        long currentSeconds = (int) (currentDuration / 1000);
        long totalSeconds = (int) (totalDuration / 1000);

        // calculating percentage
        percentage = (((double) currentSeconds) / totalSeconds) * 100;

        // return percentage
        return percentage.intValue();
    }

    public long getSeekFromPercentage(int percentage, long totalDuration) {

        long currentSeconds = 0;
        long totalSeconds = (int) (totalDuration / 1000);

        // calculating percentage
        currentSeconds = (percentage * totalSeconds) / 100;

        // return percentage
        return currentSeconds * 1000;
    }

    /**
     * Function to change progress to timer
     *
     * @param progress      -
     * @param totalDuration returns current duration in milliseconds
     */
    public int progressToTimer(int progress, int totalDuration) {
        int currentDuration = 0;
        totalDuration = totalDuration / 1000;
        currentDuration = (int) ((((double) progress) / 100) * totalDuration);

        // return current duration in milliseconds
        return currentDuration * 1000;
    }

    public int calculateTime(String duration) {
        int time = 0, min, sec, hr = 0;
        try {
            StringTokenizer st = new StringTokenizer(duration, ".");
            if (st.countTokens() == 3) {
                hr = Integer.parseInt(st.nextToken());
            }
            min = Integer.parseInt(st.nextToken());
            sec = Integer.parseInt(st.nextToken());
        } catch (Exception e) {
            StringTokenizer st = new StringTokenizer(duration, ":");
            if (st.countTokens() == 3) {
                hr = Integer.parseInt(st.nextToken());
            }
            min = Integer.parseInt(st.nextToken());
            sec = Integer.parseInt(st.nextToken());
        }
        time = ((hr * 3600) + (min * 60) + sec) * 1000;
        return time;
    }

    public void forceRTLIfSupported(Window window) {
        if (context.getResources().getString(R.string.isRTL).equals("true")) {
            window.getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        }
    }

    public boolean isAdmobFBAds() {
        return Constant.bannerAdType.equals(Constant.AD_TYPE_ADMOB) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_ADMOB) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_ADMOB) ||
                Constant.bannerAdType.equals(Constant.AD_TYPE_FACEBOOK) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_FACEBOOK) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_FACEBOOK);
    }

    public boolean isStartAppAds() {
        return Constant.bannerAdType.equals(Constant.AD_TYPE_STARTAPP) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_STARTAPP) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_STARTAPP);
    }

    public boolean isApplovinAds() {
        return Constant.bannerAdType.equals(Constant.AD_TYPE_APPLOVIN) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_APPLOVIN) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_APPLOVIN);
    }

    public boolean isWortiseAds() {
        return Constant.bannerAdType.equals(Constant.AD_TYPE_WORTISE) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_WORTISE) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_WORTISE);
    }

    public boolean isUnityAds() {
        return Constant.bannerAdType.equals(Constant.AD_TYPE_UNITY) ||
                Constant.interstitialAdType.equals(Constant.AD_TYPE_UNITY) ||
                Constant.nativeAdType.equals(Constant.AD_TYPE_UNITY);
    }

    public void initializeAds() {
        if (isAdmobFBAds()) {
            MobileAds.initialize(context, new OnInitializationCompleteListener() {
                @Override
                public void onInitializationComplete(InitializationStatus initializationStatus) {
                }
            });
        }

        if (isStartAppAds()) {
            StartAppSDK.init(context, Constant.startappAppId, false);
            StartAppAd.disableSplash();

            StartAppSDK.setTestAdsEnabled(true);

            StartAppSDK.setUserConsent(context, "pas", System.currentTimeMillis(), new GDPRChecker(context).canLoadAds());
        }

        if (isApplovinAds()) {
            if (!AppLovinSdk.getInstance(context).isInitialized()) {
                AppLovinSdkInitializationConfiguration initConfig = AppLovinSdkInitializationConfiguration.builder(context.getString(R.string.applovin_id))
                        .setMediationProvider(AppLovinMediationProvider.MAX)
                        .build();

                AppLovinSdk.getInstance(context).initialize( initConfig, sdkConfig -> { });
            }
        }

        if (isWortiseAds() && !WortiseSdk.isInitialized()) {
            WortiseSdk.initialize(context, Constant.wortiseAppId);
        }

        if (isUnityAds()) {
            UnityAds.initialize(context, Constant.unityGameId, true, new IUnityAdsInitializationListener() {
                @Override
                public void onInitializationComplete() {
                }

                @Override
                public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
                }
            });
        }
    }

    public Object showBannerAd(LinearLayout linearLayout) {
        if (isNetworkAvailable() && Constant.isBannerAd && (!new SharedPref(context).getIsSubscribed() || new SharedPref(context).getIsAdOn()) && new GDPRChecker(context).canLoadAds()) {
            switch (Constant.bannerAdType) {
                case Constant.AD_TYPE_ADMOB:
                case Constant.AD_TYPE_FACEBOOK:
                    Bundle extras = new Bundle();
                    AdView adViewAdmob = new AdView(context);
                    AdRequest adRequest;

                    if (Constant.interstitialAdType.equals(Constant.AD_TYPE_ADMOB)) {
                        adRequest = new AdRequest.Builder()
                                .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                                .build();
                    } else {
                        adRequest = new AdRequest.Builder()
                                .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                                .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                                .build();
                    }
                    adViewAdmob.setAdUnitId(Constant.bannerAdID);
                    adViewAdmob.setAdSize(AdSize.BANNER);
                    linearLayout.addView(adViewAdmob);
                    adViewAdmob.loadAd(adRequest);
                    return adViewAdmob;
                case Constant.AD_TYPE_STARTAPP:
                    Banner startAppBanner = new Banner(context);
                    startAppBanner.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                    linearLayout.addView(startAppBanner);
                    startAppBanner.loadAd();
                    return startAppBanner;
                case Constant.AD_TYPE_APPLOVIN:
                    MaxAdView adView = new MaxAdView(Constant.bannerAdID, context);
                    int width = ViewGroup.LayoutParams.MATCH_PARENT;
                    int heightPx = context.getResources().getDimensionPixelSize(R.dimen.banner_height);
                    adView.setLayoutParams(new FrameLayout.LayoutParams(width, heightPx));
                    linearLayout.addView(adView);
                    adView.loadAd();
                    return adView;
                case Constant.AD_TYPE_WORTISE:
                    BannerAd mBannerAd = new BannerAd(context);
                    mBannerAd.setAdSize(com.wortise.ads.AdSize.HEIGHT_50);
                    mBannerAd.setAdUnitId(Constant.bannerAdID);
                    linearLayout.addView(mBannerAd);
                    mBannerAd.loadAd();
                    return mBannerAd;
                case Constant.AD_TYPE_UNITY:
                    BannerView bannerView = new BannerView((Activity) context, Constant.bannerAdID, new UnityBannerSize(320, 50));
                    linearLayout.addView(bannerView);
                    bannerView.load();
                    return bannerView;
                default:
                    return null;
            }
        } else {
            return null;
        }
    }

    public void showInterAd(final int pos, final String type) {
        if (Constant.isInterAd && (!new SharedPref(context).getIsSubscribed() || new SharedPref(context).getIsAdOn()) && new GDPRChecker(context).canLoadAds()) {
            Constant.adCount = Constant.adCount + 1;
            if (Constant.adCount % Constant.interstitialAdShow == 0) {
                switch (Constant.interstitialAdType) {
                    case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK -> {
                        final AdManagerInterAdmob adManagerInterAdmob = new AdManagerInterAdmob(context);
                        if (adManagerInterAdmob.getAd() != null) {
                            adManagerInterAdmob.getAd().setFullScreenContentCallback(new FullScreenContentCallback() {
                                @Override
                                public void onAdDismissedFullScreenContent() {
                                    AdManagerInterAdmob.setAd(null);
                                    adManagerInterAdmob.createAd();
                                    interAdListener.onClick(pos, type);
                                    super.onAdDismissedFullScreenContent();
                                }

                                @Override
                                public void onAdFailedToShowFullScreenContent(@NonNull @NotNull com.google.android.gms.ads.AdError adError) {
                                    AdManagerInterAdmob.setAd(null);
                                    adManagerInterAdmob.createAd();
                                    interAdListener.onClick(pos, type);
                                    super.onAdFailedToShowFullScreenContent(adError);
                                }
                            });
                            adManagerInterAdmob.getAd().show((Activity) context);
                        } else {
                            AdManagerInterAdmob.setAd(null);
                            adManagerInterAdmob.createAd();
                            interAdListener.onClick(pos, type);
                        }
                    }
                    case Constant.AD_TYPE_STARTAPP -> {
                        final AdManagerInterStartApp adManagerInterStartApp = new AdManagerInterStartApp(context);
                        if (adManagerInterStartApp.getAd() != null && adManagerInterStartApp.getAd().isReady()) {
                            adManagerInterStartApp.getAd().showAd(new AdDisplayListener() {
                                @Override
                                public void adHidden(Ad ad) {
                                    AdManagerInterStartApp.setAd(null);
                                    adManagerInterStartApp.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void adDisplayed(Ad ad) {

                                }

                                @Override
                                public void adClicked(Ad ad) {

                                }

                                @Override
                                public void adNotDisplayed(Ad ad) {
                                    AdManagerInterStartApp.setAd(null);
                                    adManagerInterStartApp.createAd();
                                    interAdListener.onClick(pos, type);
                                }
                            });
                        } else {
                            AdManagerInterStartApp.setAd(null);
                            adManagerInterStartApp.createAd();
                            interAdListener.onClick(pos, type);
                        }
                    }
                    case Constant.AD_TYPE_APPLOVIN -> {
                        final AdManagerInterApplovin adManagerInterApplovin = new AdManagerInterApplovin(context);
                        if (adManagerInterApplovin.getAd() != null && adManagerInterApplovin.getAd().isReady()) {
                            adManagerInterApplovin.getAd().setListener(new MaxAdListener() {
                                @Override
                                public void onAdLoaded(MaxAd ad) {

                                }

                                @Override
                                public void onAdDisplayed(MaxAd ad) {

                                }

                                @Override
                                public void onAdHidden(MaxAd ad) {
                                    AdManagerInterApplovin.setAd(null);
                                    adManagerInterApplovin.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onAdClicked(MaxAd ad) {

                                }

                                @Override
                                public void onAdLoadFailed(String adUnitId, MaxError error) {
                                    AdManagerInterApplovin.setAd(null);
                                    adManagerInterApplovin.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onAdDisplayFailed(MaxAd ad, MaxError error) {
                                    AdManagerInterApplovin.setAd(null);
                                    adManagerInterApplovin.createAd();
                                    interAdListener.onClick(pos, type);
                                }
                            });
                            adManagerInterApplovin.getAd().showAd();
                        } else {
                            AdManagerInterStartApp.setAd(null);
                            adManagerInterApplovin.createAd();
                            interAdListener.onClick(pos, type);
                        }
                    }
                    case Constant.AD_TYPE_WORTISE -> {
                        final AdManagerInterWortise adManagerInterWortise = new AdManagerInterWortise(context);
                        if (adManagerInterWortise.getAd() != null && adManagerInterWortise.getAd().isAvailable()) {
                            adManagerInterWortise.getAd().setListener(new InterstitialAd.Listener() {
                                @Override
                                public void onInterstitialImpression(@NonNull InterstitialAd interstitialAd) {

                                }

                                @Override
                                public void onInterstitialClicked(@NonNull InterstitialAd interstitialAd) {

                                }

                                @Override
                                public void onInterstitialDismissed(@NonNull InterstitialAd interstitialAd) {
                                    AdManagerInterWortise.setAd(null);
                                    adManagerInterWortise.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onInterstitialFailedToLoad(@NonNull InterstitialAd interstitialAd, @NonNull AdError adError) {
                                    AdManagerInterWortise.setAd(null);
                                    adManagerInterWortise.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onInterstitialFailedToShow(@NonNull InterstitialAd interstitialAd, @NonNull AdError adError) {
                                    AdManagerInterWortise.setAd(null);
                                    adManagerInterWortise.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onInterstitialLoaded(@NonNull InterstitialAd interstitialAd) {

                                }

                                @Override
                                public void onInterstitialShown(@NonNull InterstitialAd interstitialAd) {

                                }
                            });
                            adManagerInterWortise.getAd().showAd();
                        } else {
                            AdManagerInterWortise.setAd(null);
                            adManagerInterWortise.createAd();
                            interAdListener.onClick(pos, type);
                        }
                    }
                    case Constant.AD_TYPE_UNITY -> {
                        final AdManagerInterUnity adManagerInterUnity = new AdManagerInterUnity();
                        if (AdManagerInterUnity.isAdLoaded) {
                            UnityAds.show((Activity) context, Constant.interstitialAdID, new IUnityAdsShowListener() {
                                @Override
                                public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                                    AdManagerInterUnity.setAd();
                                    adManagerInterUnity.createAd();
                                    interAdListener.onClick(pos, type);
                                }

                                @Override
                                public void onUnityAdsShowStart(String placementId) {

                                }

                                @Override
                                public void onUnityAdsShowClick(String placementId) {

                                }

                                @Override
                                public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                                    AdManagerInterUnity.setAd();
                                    adManagerInterUnity.createAd();
                                    interAdListener.onClick(pos, type);
                                }
                            });
                        } else {
                            AdManagerInterUnity.setAd();
                            adManagerInterUnity.createAd();
                            interAdListener.onClick(pos, type);
                        }
                    }
                }
            } else {
                interAdListener.onClick(pos, type);
            }
        } else {
            interAdListener.onClick(pos, type);
        }
    }

    public void showRewardAds(RewardAdListener rewardAdListener) {
        if (Constant.isRewardAd) {
            if (Constant.isSubscriptionEnabled) {
                if (new SharedPref(context).getIsSubscribed() && new SharedPref(context).getIsDownloadOn()) {
                    if (!new SharedPref(context).getIsAdOn()) {
                        rewardAdListener.onClick();
                    } else {
                        if (new SharedPref(context).getIsRewardAdWarned()) {
                            loadRewardAds(rewardAdListener);
                        } else {
                            openRewardVideoAdAlert(rewardAdListener, true);
                        }
                    }
                } else {
                    openRewardVideoAdAlert(rewardAdListener, false);
                }
            } else {
                if (new SharedPref(context).getIsRewardAdWarned()) {
                    loadRewardAds(rewardAdListener);
                } else {
                    openRewardVideoAdAlert(rewardAdListener, true);
                }
            }
        } else {
            rewardAdListener.onClick();
        }
    }

    public void loadRewardAds(RewardAdListener rewardAdListener) {
        if (new GDPRChecker(context).canLoadAds()) {
            switch (Constant.rewardAdType) {
                case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK -> {
                    final RewardAdAdmob rewardAdAdmob = new RewardAdAdmob(context);
                    if (rewardAdAdmob.getAd() != null) {
                        rewardAdAdmob.getAd().setFullScreenContentCallback(new FullScreenContentCallback() {
                            @Override
                            public void onAdDismissedFullScreenContent() {
                                RewardAdAdmob.setAd(null);
                                rewardAdAdmob.createAd();
                                if (isRewarded) {
                                    rewardAdListener.onClick();
                                }
                                super.onAdDismissedFullScreenContent();
                            }

                            @Override
                            public void onAdFailedToShowFullScreenContent(@NonNull @NotNull com.google.android.gms.ads.AdError adError) {
                                RewardAdAdmob.setAd(null);
                                rewardAdAdmob.createAd();
                                rewardAdListener.onClick();
                                super.onAdFailedToShowFullScreenContent(adError);
                            }
                        });
                        rewardAdAdmob.getAd().show((Activity) context, rewardItem -> {
                            isRewarded = true;
                        });
                    } else {
                        RewardAdAdmob.setAd(null);
                        rewardAdAdmob.createAd();
                        rewardAdListener.onClick();
                    }
                }
                case Constant.AD_TYPE_WORTISE -> {
                    final RewardAdWortise rewardAdWortise = new RewardAdWortise(context);
                    if (rewardAdWortise.getAd() != null && rewardAdWortise.getAd().isAvailable()) {
                        rewardAdWortise.getAd().setListener(new RewardedAd.Listener() {


                            @Override
                            public void onRewardedShown(@NonNull RewardedAd rewardedAd) {

                            }

                            @Override
                            public void onRewardedLoaded(@NonNull RewardedAd rewardedAd) {

                            }

                            @Override
                            public void onRewardedImpression(@NonNull RewardedAd rewardedAd) {

                            }

                            @Override
                            public void onRewardedFailedToShow(@NonNull RewardedAd rewardedAd, @NonNull AdError adError) {
                                RewardAdWortise.setAd(null);
                                rewardAdWortise.createAd();
                                rewardAdListener.onClick();
                            }

                            @Override
                            public void onRewardedFailedToLoad(@NonNull RewardedAd rewardedAd, @NonNull AdError adError) {
                                RewardAdWortise.setAd(null);
                                rewardAdWortise.createAd();
                                rewardAdListener.onClick();
                            }

                            @Override
                            public void onRewardedDismissed(@NonNull RewardedAd rewardedAd) {
                                RewardAdWortise.setAd(null);
                                rewardAdWortise.createAd();
                                if (isRewarded) {
                                    rewardAdListener.onClick();
                                }
                            }

                            @Override
                            public void onRewardedCompleted(@NonNull RewardedAd rewardedAd, @NonNull Reward reward) {
                                isRewarded = true;
                            }

                            @Override
                            public void onRewardedClicked(@NonNull RewardedAd rewardedAd) {

                            }
                        });
                        rewardAdWortise.getAd().showAd();
                    } else {
                        RewardAdWortise.setAd(null);
                        rewardAdWortise.createAd();
                        rewardAdListener.onClick();
                    }
                }
                case Constant.AD_TYPE_STARTAPP -> {
                    final RewardAdStartApp rewardAdStartApp = new RewardAdStartApp(context);
                    if (rewardAdStartApp.getAd() != null && rewardAdStartApp.getAd().isReady()) {
                        rewardAdStartApp.getAd().showAd(new AdDisplayListener() {
                            @Override
                            public void adHidden(Ad ad) {
                                RewardAdStartApp.setAd(null);
                                rewardAdStartApp.createAd();
                                if (isRewarded) {
                                    rewardAdListener.onClick();
                                }
                            }

                            @Override
                            public void adDisplayed(Ad ad) {

                            }

                            @Override
                            public void adClicked(Ad ad) {

                            }

                            @Override
                            public void adNotDisplayed(Ad ad) {
                                RewardAdStartApp.setAd(null);
                                rewardAdStartApp.createAd();
                                rewardAdListener.onClick();
                            }
                        });
                        rewardAdStartApp.getAd().setVideoListener(new VideoListener() {
                            @Override
                            public void onVideoCompleted() {
                                isRewarded = true;
                            }
                        });
                    } else {
                        RewardAdStartApp.setAd(null);
                        rewardAdStartApp.createAd();
                        rewardAdListener.onClick();
                    }
                }
                case Constant.AD_TYPE_APPLOVIN -> {
                    final RewardAdApplovin rewardAdApplovin = new RewardAdApplovin(context);
                    if (rewardAdApplovin.getAd() != null && rewardAdApplovin.getAd().isReady()) {
                        rewardAdApplovin.getAd().setListener(new MaxRewardedAdListener() {


                            @Override
                            public void onAdLoaded(@NonNull MaxAd maxAd) {

                            }

                            @Override
                            public void onAdDisplayed(@NonNull MaxAd maxAd) {

                            }

                            @Override
                            public void onAdHidden(@NonNull MaxAd maxAd) {
                                RewardAdApplovin.setAd(null);
                                rewardAdApplovin.createAd();
                                if (isRewarded) {
                                    rewardAdListener.onClick();
                                }
                            }

                            @Override
                            public void onAdClicked(@NonNull MaxAd maxAd) {

                            }

                            @Override
                            public void onAdLoadFailed(@NonNull String s, @NonNull MaxError maxError) {
                                RewardAdApplovin.setAd(null);
                                rewardAdApplovin.createAd();
                                rewardAdListener.onClick();
                            }

                            @Override
                            public void onAdDisplayFailed(@NonNull MaxAd maxAd, @NonNull MaxError maxError) {
                                RewardAdApplovin.setAd(null);
                                rewardAdApplovin.createAd();
                                rewardAdListener.onClick();
                            }

                            @Override
                            public void onUserRewarded(@NonNull MaxAd maxAd, @NonNull MaxReward maxReward) {
                                isRewarded = true;
                            }
                        });
                        rewardAdApplovin.getAd().showAd();
                    } else {
                        RewardAdApplovin.setAd(null);
                        rewardAdApplovin.createAd();
                        rewardAdListener.onClick();
                    }
                }
                case Constant.AD_TYPE_UNITY -> {
                    final RewardAdUnity rewardAdUnity = new RewardAdUnity();
                    if (RewardAdUnity.isAdLoaded) {
                        UnityAds.show((Activity) context, Constant.rewardAdsID, new IUnityAdsShowListener() {
                            @Override
                            public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                                RewardAdUnity.setAd();
                                rewardAdUnity.createAd();
                                rewardAdListener.onClick();
                            }

                            @Override
                            public void onUnityAdsShowStart(String placementId) {

                            }

                            @Override
                            public void onUnityAdsShowClick(String placementId) {

                            }

                            @Override
                            public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                                RewardAdUnity.setAd();
                                rewardAdUnity.createAd();
                                rewardAdListener.onClick();
                            }
                        });
                    } else {
                        RewardAdUnity.setAd();
                        rewardAdUnity.createAd();
                        rewardAdListener.onClick();
                    }
                }
            }
        } else {
            rewardAdListener.onClick();
        }
    }

    public boolean canLoadNativeAds(Context context) {
        return Constant.isNativeAd && new GDPRChecker(context).canLoadAds();
    }

    public void setStatusColor(Window window) {
//        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
//        window.setStatusBarColor(context.getResources().getColor(R.color.colorPrimaryDark));
//        if (!isDarkMode()) {
//            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
//        }
    }

    public void setStatusColorTransparent(Window window) {
//        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
//        window.setStatusBarColor(context.getResources().getColor(R.color.bg_status));
//        if (!isDarkMode()) {
//            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
//        }
    }

    public void setStatusColorDark(Window window) {
//        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
//        window.setStatusBarColor(context.getResources().getColor(R.color.bg_toolbar));
//        if (!isDarkMode()) {
//            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
//        }
    }

    public boolean isDarkMode() {
        int currentNightMode = context.getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
        return switch (currentNightMode) {
            case Configuration.UI_MODE_NIGHT_NO ->
                // Night mode is not active, we're using the light theme
                    false;
            case Configuration.UI_MODE_NIGHT_YES ->
                // Night mode is active, we're using dark theme
                    true;
            default -> true;
        };
    }

    public String getDarkMode() {
        SharedPref sharedPref = new SharedPref(context);
        return sharedPref.getDarkMode();
    }

    public String format(Number number) {
        char[] suffix = {' ', 'k', 'M', 'B', 'T', 'P', 'E'};
        long numValue = number.longValue();
        int value = (int) Math.floor(Math.log10(numValue));
        int base = value / 3;
        if (value >= 3 && base < suffix.length) {
            return new DecimalFormat("#0.0").format(numValue / Math.pow(10, base * 3)) + suffix[base];
        } else {
            return new DecimalFormat("#,##0").format(numValue);
        }
    }

    public int getColumnWidth(int column, int grid_padding) {
        Resources r = context.getResources();
        float padding = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, grid_padding, r.getDisplayMetrics());
        return (int) ((getScreenWidth() - ((column + 1) * padding)) / column);
    }

    public GradientDrawable getGradientDrawable(int first, int second) {
        GradientDrawable gd = new GradientDrawable();
        gd.setCornerRadius(15);
        gd.setColors(new int[]{first, second});
        gd.setGradientType(GradientDrawable.LINEAR_GRADIENT);
        gd.setOrientation(GradientDrawable.Orientation.BOTTOM_TOP);
        gd.mutate();
        return gd;
    }

    public Bitmap getBitmapFromURL(String src) {
        try {
            URL url = new URL(src);
            InputStream input;
            if (src.contains("https://")) {
                HttpsURLConnection connection = (HttpsURLConnection) url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                input = connection.getInputStream();
            } else {
                HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                input = connection.getInputStream();
            }
            return BitmapFactory.decodeStream(input);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isYoutubeAppInstalled() {
        Intent mIntent = context.getPackageManager().getLaunchIntentForPackage("com.google.android.youtube");
        return mIntent != null;
    }

    public void showBottomSheetAddToPlaylist(final ItemSong itemSong, final Boolean isOnline) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottomsheet_add_to_playlist, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context, R.style.BottomSheetDialogStyle);
        dialog.setContentView(view);
        dialog.show();

        ArrayList<ItemMyPlayList> arrayList_playlist = dbHelper.loadPlayList(isOnline);

        RecyclerView recyclerView = dialog.findViewById(R.id.rv_add_to_playlist);
        MaterialButton button_create = dialog.findViewById(R.id.button_create_playlist);
        TextView tv_empty = dialog.findViewById(R.id.tv_empty_dialog_playlist);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        recyclerView.setLayoutManager(linearLayoutManager);
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        final AdapterPlaylistDialog adapterPlaylist = new AdapterPlaylistDialog(arrayList_playlist, new ClickListenerCallback() {
            @Override
            public void onClick(int position) {
                dbHelper.addToPlayList(itemSong, arrayList_playlist.get(position).getId(), isOnline);
                Toast.makeText(context, context.getString(R.string.song_add_to_playlist) + arrayList_playlist.get(position).getName(), Toast.LENGTH_SHORT).show();
                dialog.dismiss();
            }

            @Override
            public void onItemZero() {
                recyclerView.setVisibility(View.GONE);
            }
        });
        recyclerView.setAdapter(adapterPlaylist);
        if (arrayList_playlist.size() == 0) {
            tv_empty.setVisibility(View.VISIBLE);
            recyclerView.setVisibility(View.INVISIBLE);
        }

        button_create.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
                showBottomSheetAddPlaylist(itemSong, isOnline);
            }
        });

    }

    public void showBottomSheetAddPlaylist(final ItemSong itemSong, final Boolean isOnline) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottomsheet_add_playlist, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context, R.style.BottomSheetDialogStyle);
        dialog.setContentView(view);
        dialog.show();

        MaterialButton button_add = dialog.findViewById(R.id.button_add_playlist);
        MaterialButton button_cancel = dialog.findViewById(R.id.button_add_playlist_cancel);
        EditText et_add = dialog.findViewById(R.id.et_add_playlist);

        button_add.setOnClickListener(v -> {
            if (!et_add.getText().toString().trim().isEmpty()) {
                dbHelper.addPlayList(et_add.getText().toString(), isOnline);
                Toast.makeText(context, context.getString(R.string.playlist_added), Toast.LENGTH_SHORT).show();
                showBottomSheetAddToPlaylist(itemSong, isOnline);
                dialog.dismiss();

            } else {
                Toast.makeText(context, context.getString(R.string.enter_playlist_name), Toast.LENGTH_SHORT).show();
            }
        });

        button_cancel.setOnClickListener(v -> {
            dialog.dismiss();
        });
    }

    @SuppressLint("Range")
    public void getListOfflineSongs() {
        Constant.arrayListOfflineSongs.clear();
        ContentResolver contentResolver = context.getContentResolver();
        Uri songUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;

        Cursor songCursor = contentResolver.query(songUri, null, null, null, MediaStore.Audio.Media.TITLE + " ASC");


        if (songCursor != null && songCursor.moveToFirst()) {
            do {
                String id = String.valueOf(songCursor.getLong(songCursor.getColumnIndex(MediaStore.Audio.Media._ID)));
                String title = songCursor.getString(songCursor.getColumnIndex(MediaStore.Audio.Media.TITLE));
                String artist = songCursor.getString(songCursor.getColumnIndex(MediaStore.Audio.Media.ARTIST));

                String url = "", image = "";
                url = Uri.withAppendedPath(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, id).toString();

                long albumId = songCursor.getLong(songCursor.getColumnIndex(MediaStore.Audio.Media.ALBUM_ID));
                image = getAlbumArtUri(albumId).toString();

                String desc = context.getString(R.string.title) + " - " + title + "</br>" + context.getString(R.string.artist) + " - " + artist;

                Constant.arrayListOfflineSongs.add(new ItemSong(id, artist, url, image, title, desc, "", "0", "0", "0", false));

            } while (songCursor.moveToNext());
        }
        long bb = System.currentTimeMillis();
    }

    public Uri getAlbumArtUri(int album_id) {
        Uri songCover = Uri.parse("content://media/external/audio/albumart");
        return ContentUris.withAppendedId(songCover, album_id);
    }

    public Uri getAlbumArtUri(long album_id) {
        Uri songCover = Uri.parse("content://media/external/audio/albumart");
        return ContentUris.withAppendedId(songCover, album_id);
    }

    public void shareSong(ItemSong itemSong, Boolean isOnline) {
        if (isOnline) {
            Intent sharingIntent = new Intent(android.content.Intent.ACTION_SEND);
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.share_song));
            sharingIntent.putExtra(android.content.Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - " + itemSong.getTitle() + "\n\nvia " + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
            context.startActivity(Intent.createChooser(sharingIntent, context.getResources().getString(R.string.share_song)));
        } else {
            try {
                Intent share = new Intent(Intent.ACTION_SEND);
                share.setType("audio/mp3");
                share.putExtra(Intent.EXTRA_STREAM, Uri.parse(itemSong.getUrl()));
                share.putExtra(android.content.Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - " + itemSong.getTitle() + "\n\nvia " + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
                context.startActivity(Intent.createChooser(share, context.getResources().getString(R.string.share_song)));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GradientDrawable getRoundDrawable(int color) {
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(color);
        gd.mutate();
        gd.setCornerRadius(10);
        return gd;
    }

    public GradientDrawable getRoundDrawableRadis(int color, int radius) {
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(color);
        gd.mutate();
        gd.setCornerRadius(radius);
        return gd;
    }

    public GradientDrawable getDrawableWithCornerRadius(int color, float topLeft,
                                                        float topRight, float bottomLeft, float bottomRight) {
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(color);
        gd.mutate();
        gd.setCornerRadii(new float[]{topLeft, topLeft, topRight, topRight, bottomRight, bottomRight, bottomLeft, bottomLeft});
        return gd;
    }

    public void clickLogin() {
        SharedPref sharePref = new SharedPref(context);
        if (sharePref.isLogged()) {
            openBottomSheetLogout(sharePref);
        } else {
            Intent intent = new Intent(context, LoginActivity.class);
            intent.putExtra("from", "app");
            context.startActivity(intent);
        }
    }

    public void loadLogout(SharedPref sharedPref) {
        if (isNetworkAvailable()) {
            ProgressDialog progressDialog = new ProgressDialog(context);
            progressDialog.setMessage(context.getString(R.string.logging_out));
            progressDialog.setCancelable(false);
            progressDialog.show();

            LoadLogout loadLogout = new LoadLogout(new LoggedDeviceListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String isDeviceLimitReached, String message, ArrayList<ItemLoggedDevice> arrayListLoggedDevice) {
                    progressDialog.dismiss();
                    if (success.equals("1")) {
                        logout((Activity) context, sharedPref);
                    } else {
                        Toast.makeText(context, context.getString(R.string.server_error), Toast.LENGTH_SHORT).show();
                    }
                }
            }, getAPIRequest(Constant.METHOD_LOGOUT, 0, "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserSession(), "", sharedPref.getUserID(), "", null));
            loadLogout.doWork(Constant.METHOD_LOGOUT);
        } else {
            Toast.makeText(context, context.getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void logout(Activity activity, SharedPref sharedPref) {
        try {
            if (PlayerService.exoPlayer != null) {
                Intent intent = new Intent(context, PlayerService.class);
                intent.setAction(PlayerService.ACTION_STOP);
                context.startService(intent);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        OneSignal.getUser().addTag("user_session", "");

        if (sharedPref.getLoginType().equals(Constant.LOGIN_TYPE_GOOGLE)) {
            FirebaseAuth.getInstance().signOut();
        }

        sharedPref.setIsAutoLogin(false);
        sharedPref.setIsLogged(false);
        if (sharedPref.getIsRemember()) {
            sharedPref.setLoginDetails("", "", "", sharedPref.getUserEmail(), "", "", "", true, sharedPref.getPassword(), Constant.LOGIN_TYPE_NORMAL, false);
        } else {
            sharedPref.setLoginDetails("", "", "", "", "", "", "", false, "", Constant.LOGIN_TYPE_NORMAL, false);
        }
        sharedPref.setSubscriptionDetails(false, "", "", "0", "", 0, true, false);
        Intent intent1 = new Intent(context, LoginActivity.class);
        intent1.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        intent1.putExtra("from", "");
        context.startActivity(intent1);
        activity.finish();
    }

    private void openBottomSheetLogout(SharedPref sharedPref) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_logout = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);

        btn_logout.setOnClickListener(view1 -> {
            dialog.dismiss();
            loadLogout(sharedPref);
            Toast.makeText(context, context.getResources().getString(R.string.logout_success), Toast.LENGTH_SHORT).show();
        });

        btn_cancel.setOnClickListener(view1 -> dialog.dismiss());
    }

    public void openBottomSheetForcedLogout(SharedPref sharedPref) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setCancelable(false);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_logout = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        btn_cancel.setVisibility(View.GONE);
        btn_logout.setText(context.getString(R.string.login));

        TextView tv2 = dialog.findViewById(R.id.tv2);
        tv2.setText(context.getString(R.string.logout_automatically_due_to_other_device_login));

        btn_logout.setOnClickListener(view1 -> {
            dialog.dismiss();
            Intent intent1 = new Intent(context, LoginActivity.class);
            intent1.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
            intent1.putExtra("from", "");
            context.startActivity(intent1);
            ((Activity) context).finish();
        });


        try {
            if (PlayerService.exoPlayer != null) {
                Intent intent = new Intent(context, PlayerService.class);
                intent.setAction(PlayerService.ACTION_STOP);
                context.startService(intent);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        OneSignal.getUser().addTag("user_session", "");

        if (sharedPref.getLoginType().equals(Constant.LOGIN_TYPE_GOOGLE)) {
            FirebaseAuth.getInstance().signOut();
        }

        sharedPref.setIsAutoLogin(false);
        sharedPref.setIsLogged(false);
        sharedPref.setLoginDetails("", "", "", "", "", "", "", false, "", Constant.LOGIN_TYPE_NORMAL, false);
        sharedPref.setSubscriptionDetails(false, "", "", "0", "", 0, true, false);
    }

    public void openRewardVideoAdAlert(RewardAdListener rewardAdListener, boolean isDownloadAllowed) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottom_videoad, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_watch_ad = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        SmoothCheckBox cb_videoad = dialog.findViewById(R.id.cb_videoad);
        LinearLayout ll_videoad = dialog.findViewById(R.id.ll_checkbox);
        TextView tv2 = dialog.findViewById(R.id.tv2);
        assert btn_cancel != null;
        assert btn_watch_ad != null;
        assert ll_videoad != null;
        assert tv2 != null;
        assert cb_videoad != null;

        if (!isDownloadAllowed) {
            btn_cancel.setVisibility(View.GONE);
            ll_videoad.setVisibility(View.GONE);

            TextView tv1 = dialog.findViewById(R.id.tv1);
            assert tv1 != null;
            tv1.setText(context.getString(R.string.download));

            if (new SharedPref(context).isLogged()) {
                btn_watch_ad.setText(context.getString(R.string.subscription_plans));
                tv2.setText(context.getString(R.string.download_not_allowed_in_your_subs_plan));
            } else {
                btn_watch_ad.setText(context.getString(R.string.login));
                tv2.setText(context.getString(R.string.download_not_allowed_login_and_subs));
            }
        } else {
            if (!Constant.isSubscriptionEnabled) {
                tv2.setText(context.getString(R.string.watch_video_for_download));
            }
        }

        btn_watch_ad.setOnClickListener(view1 -> {
            dialog.dismiss();
            if (isDownloadAllowed) {
                new SharedPref(context).setIsRewardAdWarned(cb_videoad.isChecked());
                loadRewardAds(() -> rewardAdListener.onClick());
            } else {
                if (new SharedPref(context).isLogged()) {
                    Intent intent = new Intent(context, SubscriptionActivity.class);
                    context.startActivity(intent);
                } else {
                    clickLogin();
                }
            }
        });

        btn_cancel.setOnClickListener(view1 -> {
            dialog.dismiss();
        });

        ll_videoad.setOnClickListener(view1 -> {
            cb_videoad.setChecked(true, true);
        });
    }

    public void download(final ItemSong itemSong) {

        File root = new File(context.getExternalFilesDir("").getAbsolutePath() + File.separator + "/temp");
        if (!root.exists()) {
            root.mkdirs();
        }

        Random random = new Random();
        String a = String.valueOf(System.currentTimeMillis());
        String name = random.nextInt((999999 - 100000) + 100000) + a.substring(a.length() - 6, a.length() - 1);

//            File file = new File(root, Constant.arrayList_play.get(viewpager.getCurrentItem()).getTitle() + ".mp3");
        File file = new File(root, name + ".mp3");

//            if (!file.exists()) {
        if (!dbHelper.checkDownload(itemSong.getId())) {

            String url = itemSong.getUrl();

            if (!DownloadService.getInstance().isDownloading()) {
                Intent serviceIntent = new Intent(context, DownloadService.class);
                serviceIntent.setAction(DownloadService.ACTION_START);
                serviceIntent.putExtra("downloadUrl", url);
                serviceIntent.putExtra("file_path", root.toString());
                serviceIntent.putExtra("file_name", file.getName());
                serviceIntent.putExtra("item", itemSong);
                context.startService(serviceIntent);
            } else {
                Intent serviceIntent = new Intent(context, DownloadService.class);
                serviceIntent.setAction(DownloadService.ACTION_ADD);
                serviceIntent.putExtra("downloadUrl", url);
                serviceIntent.putExtra("file_path", root.toString());
                serviceIntent.putExtra("file_name", file.getName());
                serviceIntent.putExtra("item", itemSong);
                context.startService(serviceIntent);
            }

            new AsyncTask<String, String, String>() {
                @Override
                protected String doInBackground(String... strings) {

                    String json = JsonUtils.okhttpPost(Constant.METHOD_DOWNLOAD_COUNT, getAPIRequest(Constant.METHOD_DOWNLOAD_COUNT, 0, "", itemSong.getId(), "", "", "", "", "", "", "", "", "", "", "", "", "", null));
//                    String json = JsonUtils.okhttpGET(Constant.URL_DOWNLOAD_COUNT + itemSong.getId());
                    return null;
                }
            }.execute();
        } else {
            Toast.makeText(context, context.getResources().getString(R.string.already_download), Toast.LENGTH_SHORT).show();
        }
    }

    @SuppressLint("Range")
    public String getPathImage(Uri uri) {
        try {
            String filePath = "";
            String wholeID = DocumentsContract.getDocumentId(uri);

            // Split at colon, use second item in the array
            String id = wholeID.split(":")[1];

            String[] column = {MediaStore.Images.Media.DATA};

            // where id is equal to
            String sel = MediaStore.Images.Media._ID + "=?";

            Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                    column, sel, new String[]{id}, null);

            int columnIndex = cursor.getColumnIndex(column[0]);

            if (cursor.moveToFirst()) {
                filePath = cursor.getString(columnIndex);
            }

            cursor.close();
            return filePath;
        } catch (Exception e) {
            e.printStackTrace();
            if (uri == null) {
                return null;
            }
            // try to retrieve the image from the media store first
            // this will only work for images selected from gallery
            String[] projection = {MediaStore.Images.Media.DATA};
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (cursor != null) {
                int column_index = cursor
                        .getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
                cursor.moveToFirst();
                String returnn = cursor.getString(column_index);
                cursor.close();

                if (returnn == null) {
                    String path = null, image_id = null;
                    Cursor cursor2 = context.getContentResolver().query(uri, null, null, null, null);
                    if (cursor2 != null) {
                        cursor2.moveToFirst();
                        image_id = cursor2.getString(0);
                        image_id = image_id.substring(image_id.lastIndexOf(":") + 1);
                        cursor2.close();
                    }

                    Cursor cursor3 = context.getContentResolver().query(android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, MediaStore.Images.Media._ID + " = ? ", new String[]{image_id}, null);
                    if (cursor3 != null) {
                        cursor3.moveToFirst();
                        path = cursor3.getString(cursor3.getColumnIndex(MediaStore.Images.Media.DATA));
                        cursor3.close();
                    }
                    return path;
                }
                return returnn;
            }
            // this is our fallback here
            return uri.getPath();
        }
    }

    public Boolean checkPerImages() {
        if (android.os.Build.VERSION.SDK_INT >= 33) {
            if ((ContextCompat.checkSelfPermission(context, READ_MEDIA_IMAGES) != PackageManager.PERMISSION_GRANTED)) {
                ((Activity) context).requestPermissions(new String[]{READ_MEDIA_IMAGES}, 102);
                return false;
            } else {
                return true;
            }
        } else if (android.os.Build.VERSION.SDK_INT >= 29) {
            if ((ContextCompat.checkSelfPermission(context, READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)) {
                ((Activity) context).requestPermissions(new String[]{READ_EXTERNAL_STORAGE}, 102);
                return false;
            } else {
                return true;
            }
        } else {
            if ((ContextCompat.checkSelfPermission(context, WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)) {

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    ((Activity) context).requestPermissions(new String[]{WRITE_EXTERNAL_STORAGE}, 102);
                    return false;
                }
            }
            return true;
        }
    }

    public Boolean checkPerAudio(int downloadReqCode) {
        if (android.os.Build.VERSION.SDK_INT >= 33) {
            if ((ContextCompat.checkSelfPermission(context, READ_MEDIA_AUDIO) != PackageManager.PERMISSION_GRANTED)) {
                ((Activity) context).requestPermissions(new String[]{READ_MEDIA_AUDIO}, downloadReqCode);
                return false;
            } else {
                return true;
            }
        } else if (android.os.Build.VERSION.SDK_INT >= 29) {
            if ((ContextCompat.checkSelfPermission(context, READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)) {
                ((Activity) context).requestPermissions(new String[]{READ_EXTERNAL_STORAGE}, downloadReqCode);
                return false;
            } else {
                return true;
            }
        } else {
            if ((ContextCompat.checkSelfPermission(context, WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)) {

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    ((Activity) context).requestPermissions(new String[]{WRITE_EXTERNAL_STORAGE}, downloadReqCode);
                    return false;
                }
            }
            return true;
        }
    }

    public Boolean checkPerNotification() {
        if (android.os.Build.VERSION.SDK_INT >= 33) {
            if ((ContextCompat.checkSelfPermission(context, POST_NOTIFICATIONS) != PackageManager.PERMISSION_GRANTED)) {
                ((Activity) context).requestPermissions(new String[]{POST_NOTIFICATIONS}, 103);
                return false;
            } else {
                return true;
            }
        }
        return true;
    }

    public Boolean getPerNotificationStatus() {
        if (android.os.Build.VERSION.SDK_INT >= 33) {
            return ContextCompat.checkSelfPermission(context, POST_NOTIFICATIONS) == PackageManager.PERMISSION_GRANTED;
        }
        return true;
    }

    public void permissionDialog() {
        if (android.os.Build.VERSION.SDK_INT >= 33) {
            Dialog dialog_sync = new Dialog(context, android.R.style.Theme_Material_Light_Dialog_Alert);
            dialog_sync.setCancelable(false);
            dialog_sync.requestWindowFeature(Window.FEATURE_NO_TITLE);
            dialog_sync.setContentView(R.layout.layout_permission);

            MaterialButton button = dialog_sync.findViewById(R.id.button_permission);
            button.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    checkPerNotification();
                    dialog_sync.dismiss();
                }
            });
            dialog_sync.show();
            Window window = dialog_sync.getWindow();
            window.setLayout(WindowManager.LayoutParams.WRAP_CONTENT, WindowManager.LayoutParams.WRAP_CONTENT);
        }
    }

    public void showUpdateAlert(String message, final boolean isFromSplash) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setCancelable(false);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_update = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);

        btn_update.setText(context.getString(R.string.update));
        tv1.setText(context.getString(R.string.update));
        tv2.setText(message);

        btn_update.setOnClickListener(view1 -> {
            dialog.dismiss();

            String url = Constant.appUpdateURL;
            if (url.equals("")) {
                url = "http://play.google.com/store/apps/details?id=" + context.getPackageName();
            }
            Intent i = new Intent(Intent.ACTION_VIEW);
            i.setData(Uri.parse(url));
            context.startActivity(i);

            ((Activity) context).finish();
        });

        if (Constant.appUpdateCancel) {
            btn_cancel.setText(context.getString(R.string.cancel));
            btn_cancel.setOnClickListener(view1 -> {
                if (isFromSplash) {
                    SharedPref sharedPref = new SharedPref(context);
                    Intent intent;
                    if (sharedPref.getIsFirst()) {
                        sharedPref.setIsFirst(false);
                        intent = new Intent(context, LoginActivity.class);
                        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                        intent.putExtra("from", "");
                    } else {
                        intent = new Intent(context, MainActivity.class);
                    }
                    context.startActivity(intent);
                    ((Activity) context).finish();
                }
            });
        } else {
            btn_cancel.setText(context.getString(R.string.exit));
            btn_cancel.setOnClickListener(view1 -> ((Activity) context).finish());
        }
    }

    public void getVerifyDialog(String title, String message) {
        final AlertDialog.Builder alertDialog = new AlertDialog.Builder(context, R.style.ThemeDialog);
        alertDialog.setTitle(title);
        alertDialog.setMessage(message);
        alertDialog.setCancelable(false);

        alertDialog.setPositiveButton(context.getString(R.string.ok), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
//                finish();
            }
        });
        alertDialog.show();
    }

    public void getInvalidUserDialog(String message) {
        final AlertDialog.Builder alertDialog = new AlertDialog.Builder(context, R.style.ThemeDialog);
        alertDialog.setTitle(context.getString(R.string.invalid_user));
        alertDialog.setMessage(message);
        alertDialog.setCancelable(false);

        alertDialog.setPositiveButton(context.getString(R.string.ok), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                logout((Activity) context, new SharedPref(context));
            }
        });
        alertDialog.show();
    }

    public void loadAddTransaction(ItemSubscriptionPlan itemSubscriptionPlan, String paymentGateway, String paymentID) {
        if (isNetworkAvailable()) {
            ProgressDialog progressDialog = new ProgressDialog(context);
            progressDialog.setMessage(context.getString(R.string.loading));
            progressDialog.setCancelable(false);
            progressDialog.show();

            LoadAddTransaction loadAddTransaction = new LoadAddTransaction(new AddTransactionListener() {
                @Override
                public void onStart() {
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String expiresOn) {
                    progressDialog.dismiss();
                    if (success.equals("1")) {
                        new SharedPref(context).setSubscriptionDetails(true, itemSubscriptionPlan.getId(), itemSubscriptionPlan.getTitle(), expiresOn, itemSubscriptionPlan.getDuration(), itemSubscriptionPlan.getDeviceLimit(), itemSubscriptionPlan.isAdsOn(), itemSubscriptionPlan.isDownloadOn());
                        showPaymentSuccessDialog(paymentID, paymentGateway, expiresOn);
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                    Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                }
            }, getAPIRequest(Constant.METHOD_ADD_TRANSACTION, 0, paymentID, "", paymentGateway, "", "", "", "", itemSubscriptionPlan.getId(), "", "", "", "", "", new SharedPref(context).getUserID(), "", null));
            loadAddTransaction.doWork(Constant.METHOD_ADD_TRANSACTION);
        } else {
            Toast.makeText(context, context.getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void showPaymentSuccessDialog(String paymentID, String paymentGateway, String expiresOn) {
        final Dialog dialog = new Dialog(context);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setCancelable(false);
        dialog.setContentView(R.layout.layout_dialog_success);

        MaterialButton dialogButton = dialog.findViewById(R.id.btn_dialog_success);
        TextView tv_paymentID = dialog.findViewById(R.id.tv_success_paymentID);
        TextView tv_paymentName = dialog.findViewById(R.id.tv_success_paymentName);
        TextView tv_expires = dialog.findViewById(R.id.tv_success_expires);

        tv_paymentID.setText(paymentID);
        tv_paymentName.setText(paymentGateway);
        tv_expires.setText(expiresOn);

        dialogButton.setOnClickListener(v -> {
            dialog.dismiss();
            Intent intent = new Intent(context, MainActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            context.startActivity(intent);
            ((Activity) context).finish();
        });

        dialog.show();
        dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

    }

    public RequestBody getAPIRequest(String method, int page, String paymentID, String
            songID, String searchText, String type, String catID, String albumID, String
                                             artistID, String playList_plan_ID, String rate, String email, String password, String name, String
                                             phone, String userID, String reportMessage, File file) {
        JsonObject jsObj = (JsonObject) new Gson().toJsonTree(new API());
        jsObj.addProperty("package_name", context.getPackageName());

        switch (method) {
            case Constant.METHOD_APP_DETAILS -> jsObj.addProperty("os_name", "android");
            case Constant.METHOD_HOME -> {
                jsObj.addProperty("user_id", userID);
                if (!songID.equals("")) {
                    jsObj.addProperty("songs_ids", songID);
                }
            }
            case Constant.METHOD_SONG_BY_LATEST, Constant.METHOD_ALL_SONGS, Constant.METHOD_SONG_BY_TRENDING ->
                    jsObj.addProperty("user_id", userID);
            case Constant.METHOD_SONG_DETAIL -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("song_id", songID);
            }
            case Constant.METHOD_SEARCH -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("search_text", searchText);
            }
            case Constant.METHOD_SEARCH_SINGLE -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("search_text", searchText);
                jsObj.addProperty("search_type", type);
            }
            case Constant.METHOD_SONG_BY_RECENT -> {
                jsObj.addProperty("songs_ids", songID);
                jsObj.addProperty("user_id", userID);
            }
            case Constant.METHOD_SONG_BY_FAV -> jsObj.addProperty("user_id", userID);
            case Constant.METHOD_SONG_BY_CATEGORY -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("category_id", catID);
            }
            case Constant.METHOD_SONG_BY_ALBUMS -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("album_id", albumID);
            }
            case Constant.METHOD_SONG_BY_ARTISTS -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("artist_id", artistID);
            }
            case Constant.METHOD_SONG_BY_PLAYLIST -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("playlist_id", playList_plan_ID);
            }
            case Constant.METHOD_SONG_BY_BANNER -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("slider_id", catID);
            }
            case Constant.METHOD_HOME_DETAILS -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("id", catID);
            }
            case Constant.METHOD_SONG_RATE -> {
                jsObj.addProperty("post_id", songID);
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("rate", rate);
            }
            case Constant.METHOD_LOGIN -> {

                StringBuilder sb = new StringBuilder(Build.BRAND);
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));

                jsObj.addProperty("email", email);
                jsObj.addProperty("password", password);
                jsObj.addProperty("brand", sb.toString());
                jsObj.addProperty("model", Build.MODEL);
                jsObj.addProperty("platform", "Android");
            }
            case Constant.METHOD_SOCIAL_LOGIN -> {
                StringBuilder sb = new StringBuilder(Build.BRAND);
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));

                jsObj.addProperty("name", name);
                jsObj.addProperty("email", email);
                jsObj.addProperty("social_id", paymentID);
                jsObj.addProperty("login_type", type);
                jsObj.addProperty("brand", sb.toString());
                jsObj.addProperty("model", Build.MODEL);
                jsObj.addProperty("platform", "Android");
            }
            case Constant.METHOD_REGISTER -> {
                jsObj.addProperty("name", name);
                jsObj.addProperty("email", email);
                jsObj.addProperty("password", password);
                jsObj.addProperty("phone", phone);
            }
            case Constant.METHOD_FORGOT_PASSWORD -> jsObj.addProperty("email", email);
            case Constant.METHOD_PROFILE -> jsObj.addProperty("user_id", userID);
            case Constant.METHOD_PROFILE_EDIT -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("name", name);
                jsObj.addProperty("email", email);
                jsObj.addProperty("password", password);
                jsObj.addProperty("phone", phone);
            }
            case Constant.METHOD_REPORT -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("post_id", songID);
                jsObj.addProperty("message", reportMessage);
            }
            case Constant.METHOD_SUGGESTION -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("title", name);
                jsObj.addProperty("message", reportMessage);
            }
            case Constant.METHOD_DOWNLOAD_COUNT, Constant.METHOD_SONG_VIEW ->
                    jsObj.addProperty("post_id", songID);
            case Constant.METHOD_SONG_FAVOURITE -> {
                jsObj.addProperty("post_id", songID);
                jsObj.addProperty("user_id", userID);
            }
            case Constant.METHOD_DELETE_ACCOUNT,
                    Constant.METHOD_CHECK_USER_PLAN,
                    Constant.METHOD_USER_ACTIVE_DEVICE_LIST -> jsObj.addProperty("user_id", userID);

            case Constant.METHOD_CHECK_USER_DEVICE_LIMIT_REACHED -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("plan_id", playList_plan_ID);
            }
            case Constant.METHOD_LOGOUT -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("user_session_name", name);
            }
            case Constant.METHOD_ADD_TRANSACTION -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("plan_id", playList_plan_ID);
                jsObj.addProperty("payment_id", paymentID);
                jsObj.addProperty("payment_gateway", searchText);
            }
            case Constant.METHOD_RAZORPAY_ORDER_ID -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("amount", searchText);
            }
            case Constant.METHOD_INSTAMOJO_ORDER_ID -> {
                jsObj.addProperty("user_id", userID);
                jsObj.addProperty("plan_id", playList_plan_ID);
            }
            case Constant.METHOD_STRIPE_TOKEN -> {
                jsObj.addProperty("amount", searchText);
            }
            case Constant.METHOD_BRAINTREE_CHECKOUT -> {
                jsObj.addProperty("payment_amount", searchText);
                jsObj.addProperty("payment_nonce", paymentID);
            }
            case Constant.METHOD_PAYUMONEY_HASH -> {
                jsObj.addProperty("hashdata", searchText);
            }
            case Constant.METHOD_TRANSACTION -> {
                jsObj.addProperty("user_id", userID);
            }
            default -> {
            }
        }

//        Log.e("aaa", API.toBase64(jsObj.toString()));
        if (method.equals(Constant.METHOD_SUGGESTION)) {
            final MediaType MEDIA_TYPE_PNG = MediaType.parse("image/*");

            return new MultipartBody.Builder()
                    .setType(MultipartBody.FORM)
                    .addFormDataPart("image", file.getName(), RequestBody.create(MEDIA_TYPE_PNG, file))
                    .addFormDataPart("data", API.toBase64(jsObj.toString()))
                    .build();
        } else if (method.equals(Constant.METHOD_PROFILE_EDIT) && file != null) {
            final MediaType MEDIA_TYPE_PNG = MediaType.parse("image/*");

            return new MultipartBody.Builder()
                    .setType(MultipartBody.FORM)
                    .addFormDataPart("user_image", file.getName(), RequestBody.create(MEDIA_TYPE_PNG, file))
                    .addFormDataPart("data", API.toBase64(jsObj.toString()))
                    .build();
        } else {
            return new MultipartBody.Builder()
                    .setType(MultipartBody.FORM)
                    .addFormDataPart("data", API.toBase64(jsObj.toString()))
                    .build();
        }
    }
}