package com.vpapps.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPref {

    EncryptData encryptData;
    SharedPreferences sharedPreferences;
    SharedPreferences.Editor editor;
    static String TAG_UID = "uid" ,TAG_USERNAME = "name", TAG_EMAIL = "email", TAG_MOBILE = "mobile", TAG_IMAGE = "proimage",
            TAG_REMEMBER = "rem", TAG_AUTH_ID = "auth_id", TAG_IS_LOGGED = "islogged", TAG_PASSWORD = "pass",
            SHARED_PREF_AUTOLOGIN = "autologin", TAG_LOGIN_TYPE = "loginType", TAG_NIGHT_MODE = "nightmode",
            TAG_FB = "fb", TAG_INSTA = "insta", TAG_TWITTER = "twitter", TAG_YOUTUBE = "youtube", TAG_USER_SESSION_NAME = "user_session_name",
            TAG_IS_SUBSCRIBED = "is_subs", TAG_CURRENT_PLAN="current_plan", TAG_EXPIRE_ON="expire_on",
            TAG_DEVICE_LIMIT = "device_limit", TAG_IS_AD_ON = "is_ad_on", TAG_IS_DOWNLOAD_ON = "is_download_on",
            TAG_IS_DEVICE_LIMIT_REACHED = "is_device_limit", TAG_SUBSCRIPTION_PLAN_ID="subs_plan_id", TAG_SUBSCRIPTION_AMOUNT="subs_plan_amount",
            TAG_REWARD_AD_WARNING= "is_reward_ad_warned";

    public SharedPref(Context context) {
        encryptData = new EncryptData(context);
        sharedPreferences = context.getSharedPreferences("setting", Context.MODE_PRIVATE);
        editor = sharedPreferences.edit();
    }

    public void setIsFirst(Boolean flag) {
        editor.putBoolean("firstopen", flag);
        editor.apply();
    }

    public Boolean getIsFirst() {
        return sharedPreferences.getBoolean("firstopen", true);
    }

    public boolean isLogged() {
        return sharedPreferences.getBoolean(TAG_IS_LOGGED, false);
    }

    public void setIsLogged(Boolean isLogged) {
        editor.putBoolean(TAG_IS_LOGGED, isLogged);
        editor.apply();
    }

    public void setLoginDetails(String id, String name, String mobile, String email, String image, String userSessionName, String authID, Boolean isRemember, String password, String loginType, boolean isDeviceLimitReached) {
        editor.putBoolean(TAG_REMEMBER, isRemember);
        editor.putString(TAG_UID, encryptData.encrypt(id));
        editor.putString(TAG_USERNAME, encryptData.encrypt(name));
        editor.putString(TAG_MOBILE, encryptData.encrypt(mobile));
        editor.putString(TAG_EMAIL, encryptData.encrypt(email));
        editor.putString(TAG_IMAGE, encryptData.encrypt(image));
        editor.putString(TAG_USER_SESSION_NAME, encryptData.encrypt(userSessionName));
        editor.putBoolean(TAG_REMEMBER, isRemember);
        editor.putString(TAG_PASSWORD, encryptData.encrypt(password));
        editor.putString(TAG_LOGIN_TYPE, encryptData.encrypt(loginType));
        editor.putString(TAG_AUTH_ID, encryptData.encrypt(authID));
        editor.putBoolean(TAG_IS_DEVICE_LIMIT_REACHED, isDeviceLimitReached);
        editor.apply();
    }

    public void setSubscriptionDetails(boolean isSubscribed, String planID, String currentPlan, String amount, String expireOn, int deviceLimit, boolean isAdOn, boolean isDownloadOn) {
        editor.putBoolean(TAG_IS_SUBSCRIBED, isSubscribed);
        editor.putString(TAG_SUBSCRIPTION_PLAN_ID, planID);
        editor.putString(TAG_CURRENT_PLAN, currentPlan);
        editor.putString(TAG_SUBSCRIPTION_AMOUNT, amount);
        editor.putString(TAG_EXPIRE_ON, expireOn);
        editor.putInt(TAG_DEVICE_LIMIT, deviceLimit);
        editor.putBoolean(TAG_IS_AD_ON, isAdOn);
        editor.putBoolean(TAG_IS_DOWNLOAD_ON, isDownloadOn);
        editor.apply();
    }

    public void setSocialDetails() {
        editor.putString(TAG_FB, Constant.urlFacebook);
        editor.putString(TAG_INSTA, Constant.urlInstagram);
        editor.putString(TAG_TWITTER, Constant.urlTwitter);
        editor.putString(TAG_YOUTUBE, Constant.urlYoutube);
        editor.apply();
    }

    public void setRemember(Boolean isRemember) {
        editor.putBoolean(TAG_REMEMBER, isRemember);
        editor.putString(TAG_PASSWORD, "");
        editor.apply();
    }

    public String getDarkMode() {
        return sharedPreferences.getString(TAG_NIGHT_MODE, Constant.DARK_MODE_ON);
    }

    public void setDarkMode(String nightMode) {
        editor.putString(TAG_NIGHT_MODE, nightMode);
        editor.apply();
    }

    public String getUserID() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_UID,""));
    }

    public void setUserName(String userName) {
        editor.putString(TAG_USERNAME, encryptData.encrypt(userName));
        editor.apply();
    }

    public String getUserName() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_USERNAME, ""));
    }

    public void setUserSession(String usersession) {
        editor.putString(TAG_USER_SESSION_NAME, encryptData.encrypt(usersession));
        editor.apply();
    }

    public String getUserSession() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_USER_SESSION_NAME, ""));
    }

    public void setUserImage(String image) {
        editor.putString(TAG_IMAGE, encryptData.encrypt(image));
        editor.apply();
    }

    public String getUserImage() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_IMAGE,""));
    }

    public void setUserEmail(String email) {
        editor.putString(TAG_EMAIL, encryptData.encrypt(email));
        editor.apply();
    }

    public String getUserEmail() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_EMAIL,""));
    }

    public void setUserMobile(String mobile) {
        editor.putString(TAG_MOBILE, encryptData.encrypt(mobile));
        editor.apply();
    }

    public String getUserMobile() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_MOBILE, ""));
    }

    public String getPassword() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_PASSWORD,""));
    }

    public Boolean isRemember() {
        return sharedPreferences.getBoolean(TAG_REMEMBER, false);
    }

    public Boolean getIsNotification() {
        return sharedPreferences.getBoolean("noti", true);
    }

    public void setIsNotification(Boolean isNotification) {
        editor.putBoolean("noti", isNotification);
        editor.apply();
    }

    public Boolean getIsAutoLogin() {
        return sharedPreferences.getBoolean(SHARED_PREF_AUTOLOGIN, false);
    }

    public void setIsAutoLogin(Boolean isAutoLogin) {
        editor.putBoolean(SHARED_PREF_AUTOLOGIN, isAutoLogin);
        editor.apply();
    }

    public Boolean getIsRemember() {
        return sharedPreferences.getBoolean(TAG_REMEMBER, false);
    }

    public String getLoginType() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_LOGIN_TYPE,""));
    }

    public String getAuthID() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_AUTH_ID,""));
    }

    public String getFB() {
        return sharedPreferences.getString(TAG_FB,"");
    }

    public String getTwitter() {
        return sharedPreferences.getString(TAG_TWITTER,"");
    }

    public String getInsta() {
        return sharedPreferences.getString(TAG_INSTA,"");
    }

    public String getYotube() {
        return sharedPreferences.getString(TAG_YOUTUBE,"");
    }


    public void setCheckSleepTime() {
        if (getSleepTime() <= System.currentTimeMillis()) {
            setSleepTime(false, 0, 0);
        }
    }

    public void setSleepTime(Boolean isTimerOn, long sleepTime, int id) {
        editor.putBoolean("isTimerOn", isTimerOn);
        editor.putLong("sleepTime", sleepTime);
        editor.putInt("sleepTimeID", id);
        editor.apply();
    }

    public Boolean getIsSleepTimeOn() {
        return sharedPreferences.getBoolean("isTimerOn", false);
    }

    public long getSleepTime() {
        return sharedPreferences.getLong("sleepTime", 0);
    }

    public int getSleepID() {
        return sharedPreferences.getInt("sleepTimeID", 0);
    }

    public Boolean getIsSubscribed() {
        return sharedPreferences.getBoolean(TAG_IS_SUBSCRIBED, false);
    }

    public String getSubscriptionPlanID() {
        return sharedPreferences.getString(TAG_SUBSCRIPTION_PLAN_ID,"");
    }

    public String getSubscriptionPlanName() {
        return sharedPreferences.getString(TAG_CURRENT_PLAN,"");
    }

    public String getSubscriptionPlanAmount() {
        return sharedPreferences.getString(TAG_SUBSCRIPTION_AMOUNT,"0");
    }

    public String getSubscriptionPlanExpireOn() {
        return sharedPreferences.getString(TAG_EXPIRE_ON,"");
    }

    public int getDeviceLimit() {
        return sharedPreferences.getInt(TAG_DEVICE_LIMIT,1);
    }

    public boolean getIsAdOn() {
        return sharedPreferences.getBoolean(TAG_IS_AD_ON,true);
    }

    public boolean getIsDownloadOn() {
        return sharedPreferences.getBoolean(TAG_IS_DOWNLOAD_ON,false);
    }

    public boolean isDeviceLimitReached() {
        return sharedPreferences.getBoolean(TAG_IS_DEVICE_LIMIT_REACHED,false);
    }

    public void setIsDeviceLimitReached(boolean deviceLimitReached) {
        editor.putBoolean(TAG_IS_DEVICE_LIMIT_REACHED, deviceLimitReached);
        editor.apply();
    }

    public Boolean getIsRewardAdWarned() {
        return sharedPreferences.getBoolean(TAG_REWARD_AD_WARNING, false);
    }

    public void setIsRewardAdWarned(Boolean isRewardAdWarned) {
        editor.putBoolean(TAG_REWARD_AD_WARNING, isRewardAdWarned);
        editor.apply();
    }
}