package com.vpapps.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.vpapps.onlinemp3.PlayerService;

public class SleepTimerReceiver extends BroadcastReceiver {

    SharedPref sharedPref;

    @Override
    public void onReceive(final Context context, Intent intent) {
        sharedPref = new SharedPref(context);

        try {
            if (sharedPref.getIsSleepTimeOn()) {
                sharedPref.setSleepTime(false, 0, 0);

                Intent intent_close = new Intent(context, PlayerService.class);
                intent_close.setAction(PlayerService.ACTION_STOP);
                context.startService(intent_close);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}